<?php
// ++=========================================================================++
// || vBadvanced CMPS v2.2.1 (vB 3.6) - 53038
// ||  2003-2007 vBadvanced.com & PlurPlanet, LLC - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || Downloaded 18:49, Mon Jan 29th 2007
// || 
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

$specialtemplates = array(
	'adv_portal_opts',
	'bbcodecache'
);

if ($_REQUEST['do'] == 'menu')
{
	$phrasegroups = array('cphome');
}
else
{
	$phrasegroups = array('adv_portal_cp');
	if (in_array($_REQUEST['do'], array('editmodule', 'addmodule', 'copymodule', 'addpage', 'editpage', 'copypage')))
	{
		$phrasegroups[] = 'posting';
	}
}

require_once('./global.php');
require_once('./includes/adminfunctions_vba_cmps.php');

if (!isset($_REQUEST['do']))
{
	$_REQUEST['do'] = 'frameset';
}

// ##### Build frameset #######################################################
if ($_REQUEST['do'] == 'frameset')
{
	$navframe = '<frame src="vba_cmps_admin.php?do=menu" name="nav" scrolling="yes" border="no" />';
	$mainframe = '<frame src="vba_cmps_admin.php?do=main" name="main" scrolling="yes" border="no" />';

	echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd">
	<html dir="' . $stylevar['textdirection'] . '" lang="'. $stylevar['languagecode'] . '">
	<head>
		<title>vBadvanced ' . $vbphrase['admin_control_panel'] . '</title>
		<script type="text/javascript">
		<!-- //
		if (self.parent.frames.length != 0)
		{
			document.write(\'Get me out of this frame set!\');
			self.parent.location.replace(document.location.href);
		}
		// -->
		</script>
	</head>
	<frameset cols="' . iif($stylevar['textdirection'] == 'ltr', '195,*', '*,195') . '" framespacing="0" border="0" frameborder="0" frameborder="no" border="0">
			' . iif($stylevar['textdirection'] == 'ltr', $navframe . $mainframe, $mainframe . $navframe);
	exit;
}

// ##### Nav menu #############################################################
if ($_REQUEST['do'] == 'menu')
{
	require_once('./includes/adminfunctions_navpanel.php');
	print_cp_header();

	echo '<div><img alt="" border="" src="../cpstyles/vba_cp_logo.gif" title="' . $vbphrase['admin_control_panel'] . '" hspace="4" vspace="4" /></div><div style="width:168px; padding:4px">';

	echo '<br /><div class="navtitle">' . $vbphrase['vba_cmps'] . '</div><div class="navgroup">';

	construct_nav_option($vbphrase['default_settings'], 'vba_cmps_admin.php?do=modifysettings');
	construct_nav_option($vbphrase['edit_modules'], 'vba_cmps_admin.php?do=listmodules');
	construct_nav_option($vbphrase['add_module'], 'vba_cmps_admin.php?do=newmodule');
	construct_nav_option($vbphrase['edit_pages'], 'vba_cmps_admin.php?do=listpages');
	construct_nav_option($vbphrase['add_page'], 'vba_cmps_admin.php?do=newpage');
	construct_nav_option($vbphrase['download_upload_module'], 'vba_cmps_admin.php?do=download');
	construct_nav_option($vbphrase['quick_permissions_editor'], 'vba_cmps_admin.php?do=permissions');

	foreach ($options AS $links)
	{
		echo $links;
	}
	exit;
}

// ##### Download Module ######################################################
if ($_REQUEST['do'] == 'downloadmodule')
{
	$module = $db->query_first("SELECT title, identifier, filename, inctype, parent, templatelist, colspan, formcode, cleanoutput, options, useshell, link FROM " . TABLE_PREFIX . "adv_modules WHERE modid = " . intval($_REQUEST['modid']));

	$moduleinfo['module'] = serialize($module);

	if (($module['inctype'] == 'php_file' AND $module['filename']) OR $module['templatelist'] OR ($module['filename'] AND $module['inctype'] == 'template'))
	{
		$tnames = iif($module['templatelist'], explode(',', str_replace(' ', '', $module['templatelist'])), array('adv_portal_' . $module['filename']));

		if (!empty($tnames))
		{
			$template = array();
			$templates = $db->query_read("SELECT title, template_un FROM " . TABLE_PREFIX . "template WHERE title IN('" . implode("', '", $tnames) . "')");
			while ($temp = $db->fetch_array($templates))
			{
				$template["$temp[title]"] = stripslashes($temp['template_un']);
			}
		}

		if (!empty($template))
		{
			$moduleinfo['templates'] = serialize($template);
		}

		if ($fp = @fopen('./modules/' . $module['filename'], 'r'))
		{
			$moduleinfo['file'] = fread($fp, filesize('./modules/' . $module['filename']));
			fclose($fp);
		}
	}

	if ($module['inctype'] == 'php_file')
	{
		$getphrases = $db->query_read("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE fieldname = 'vbsettings' ORDER BY languageid ASC");
		while($phrases = $db->fetch_array($getphrases))
		{
			$settingphrase["$phrases[varname]"] = $phrases['text'];
		}

		$modsettings = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = 'adv_portal_$module[identifier]'");
		while ($setting = $db->fetch_array($modsettings))
		{
			$moduleinfo['settings']["$setting[varname]"] = $setting;
			$moduleinfo['settings']["$setting[varname]"]['title'] = $settingphrase["setting_$setting[varname]_title"];
			$moduleinfo['settings']["$setting[varname]"]['description'] = $settingphrase["setting_$setting[varname]_desc"];
		}
	}

	$moduleinfo = serialize($moduleinfo);

	header('Content-Type: application/octetstream');
	header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Content-Disposition: attachment; filename="' . strtolower(preg_replace("/[^a-z_0-9]/i", '' , $module['title'])) . '.module"');
	header('Content-Length: ' . strlen($moduleinfo));
	header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
	header('Pragma: public');

	echo $moduleinfo;
	exit;
}

// Go ahead and grab page/module info to see if we need editInit()
if (isset($_REQUEST['type']))
{
	$type = $_REQUEST['type'];
}

if ($_REQUEST['do'] == 'editmodule' OR $_REQUEST['do'] == 'copymodule')
{
	$module = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_modules WHERE modid = " . intval($_REQUEST['modid']));

	if (!isset($type) AND !isset($_REQUEST['chtype']))
	{
		$type = $module['inctype'];
	}
}

// Go ahead and get page info
if ($_REQUEST['do'] == 'addpage' OR $_REQUEST['do'] == 'editpage' OR $_REQUEST['do'] == 'copypage')
{
	$getpages = $db->query("SELECT * FROM " . TABLE_PREFIX . "adv_pages ORDER BY displayorder");
	while ($pages = $db->fetch_array($getpages))
	{
		$pagecache["$pages[pageid]"] = $pages;
	}

	$db->free_result($getpages);
	unset($pages);

	if ($_REQUEST['do'] != 'addpage')
	{
		$page = $pagecache["$_REQUEST[pageid]"];

		if (!isset($_REQUEST['type']) AND !isset($_REQUEST['chtype']))
		{
			$type = $page['type'];
		}
	}
}

// Print Admin Header
print_cp_header($vbphrase['vbadvanced_cmps']);

$cmps_options =& $vbulletin->adv_portal_opts;
$vba_options = array_merge($cmps_options['adv_portal_main'], $cmps_options['adv_global']);

// ##### Main admin page ######################################################
if ($_REQUEST['do'] == 'main')
{
	$cversion = @file_get_contents('http://license.vbadvanced.com/?p=4', 'r');

	$getversion = explode(' ', $vba_options['portal_version']);
	$pversion = $getversion[0];

	print_form_header('', '');
	print_table_header($vbphrase['welcome_to_vba_cmps_control_panel']);
	print_description_row(iif($cversion, construct_phrase($vbphrase['currently_running_latest_available'], $vba_options['portal_version'], $cversion, iif($cversion == $pversion, $vbphrase['your_vba_version_up_to_date'], $vbphrase['newer_version_available'])), $vbphrase['version_info_unavailable']));
	print_table_footer();

}

if ($_REQUEST['do'] == 'noaction')
{
	print_stop_message('invalid_action_specified');
}

// ##### Modify Settings ######################################################
if ($_REQUEST['do'] == 'modifysettings')
{
	$showall = intval($_REQUEST['showall']);

	echo '<div align="center">' . construct_link_code(iif($showall, $vbphrase['hide_module_settings'], $vbphrase['show_module_settings']), 'vba_cmps_admin.php?do=modifysettings&amp;showall=' . iif($showall, 0, 1)) . '</div>';

	print_form_header('vba_cmps_admin', 'saveopts');

	print_adv_setting_group('mainsettings' . iif($showall, '_all'));
	construct_hidden_code('showall', $showall);

	print_submit_row();
}

// ##### Save Settings ########################################################
if ($_POST['do'] == 'saveopts')
{
	$setting = $_POST['setting'];

	construct_cmps_settings();

	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]do=modifysettings&showall=$_POST[showall]", 0);
}

// ##### Add / Edit Setting ###################################################
if ($_REQUEST['do'] == 'addsetting' OR $_REQUEST['do'] == 'editsetting')
{
	$varname = $_REQUEST['varname'];
	$identifier = htmlspecialchars($_REQUEST['identifier']);

	print_form_header('vba_cmps_admin', 'do' . $_REQUEST['do']);
	print_table_header(iif($_REQUEST['do'] == 'editsetting', $vbphrase['edit_setting'] . ': ' . $varname, $vbphrase['add_setting']));
	construct_hidden_code('modid', $_REQUEST['modid']);

	if ($_REQUEST['do'] == 'editsetting')
	{
		$setting = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$_REQUEST[varname]' AND grouptitle = 'adv_portal_$_REQUEST[identifier]'");

		construct_hidden_code('setting[varname]', $setting['varname']);
		print_label_row($vbphrase['varname'], '<b>' . $setting['varname'] . '</b>');
		$identifier = $setting['grouptitle'];

		$phrases = $db->query_read("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE varname IN ('setting_$setting[varname]_title', 'setting_$setting[varname]_desc') AND fieldname = 'vbsettings'");
		while ($phrase = $db->fetch_array($phrases))
		{
			if ($phrase['varname'] == "setting_$setting[varname]_title")
			{
				$setting['title'] = $phrase['text'];
			}
			else
			{
				$setting['description'] = $phrase['text'];
			}
		}
	}
	else
	{
		print_input_row($vbphrase['varname'], 'setting[varname]', $setting['varname']);
	}
	print_input_row($vbphrase['title'], 'setting[title]', $setting['title']);
	construct_hidden_code('setting[identifier]', $identifier);
	print_textarea_row($vbphrase['description'], 'setting[description]', $setting['description']);
	print_textarea_row($vbphrase['option_code'], 'setting[optioncode]', $setting['optioncode'], 4, 50);
	print_textarea_row($vbphrase['default'], 'setting[defaultvalue]', $setting['defaultvalue'], 4, 50);
	print_input_row($vbphrase['display_order'], 'setting[displayorder]', $setting['displayorder']);
	print_submit_row();
}

// ##### Do Add Setting #######################################################
if ($_POST['do'] == 'doaddsetting')
{
	$setting = $_POST['setting'];
	$modid = intval($_POST['modid']);

	if (!$checkphrase = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $setting['varname'] . "_title' OR varname = 'setting_" . $setting['varname'] . "_desc'"))
	{
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "phrase
				(languageid, varname, text, fieldname, product)
			VALUES (
				0,
				'setting_" . $setting['varname'] . "_title',
				'" . $db->escape_string(htmlspecialchars($setting['title'])) ."',
				'vbsettings',
				'adv_cmps'
		)");
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "phrase
				(languageid, varname, text, fieldname, product)
			VALUES (
				0,
				'setting_" . $setting['varname'] . "_desc',
				'" . $db->escape_string($setting['description']) . "',
				'vbsettings',
				'adv_cmps'
		)");
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_setting
			(varname, grouptitle, value, defaultvalue, optioncode, displayorder)
		VALUES (
			'$setting[varname]',
			'adv_portal_$setting[identifier]',
			'$setting[defaultvalue]',
			'$setting[defaultvalue]',
			'" . $db->escape_string($setting['optioncode']) . "',
			'$setting[displayorder]'
	)");

	build_adv_settings();

	print_cp_redirect('vba_cmps_admin.php?' . $session['sessionurl'] . iif($modid, 'do=editmodule&modid=' . $modid, 'modifysettings'), 0);

}

// ##### Do Edit Setting ######################################################
if ($_POST['do'] == 'doeditsetting')
{
	$setting = $_POST['setting'];
	$modid = intval($_POST['modid']);

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "adv_setting SET 
			defaultvalue = '$setting[defaultvalue]',
			optioncode = '" . $db->escape_string($setting['optioncode']) . "',
			displayorder = '$setting[displayorder]' 
		WHERE varname = '$setting[varname]' AND grouptitle = '$setting[identifier]'
	");

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "phrase SET text = '" . $db->escape_string($setting['description']) . "' WHERE varname = 'setting_" . $setting['varname'] . "_desc' AND fieldname = 'vbsettings'");

	$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET text = '" . $db->escape_string($setting['title']) . "' WHERE varname = 'setting_" . $setting['varname'] . "_title' AND fieldname = 'vbsettings'");

	if ($modid)
	{
		print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]do=editmodule&modid=$modid#settings", 0);
	}
	else
	{
		print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]do=modifysettings", 0);
	}
}

// ##### Remove Setting #######################################################
if ($_REQUEST['do'] == 'removesetting')
{
	$varname = htmlspecialchars($_REQUEST['varname']);
	$grouptitle = htmlspecialchars($_REQUEST['grouptitle']);
	$identifier = htmlspecialchars($_REQUEST['identifier']);

	if ($identifier)
	{
		$grouptitle = 'adv_portal_' . $identifier;
	}

	print_form_header('vba_cmps_admin', 'doremovesetting');
	construct_hidden_code('varname', $varname);
	construct_hidden_code('grouptitle', $grouptitle);
	construct_hidden_code('modid', intval($_REQUEST['modid']));
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row(construct_phrase($vbphrase['are_you_sure_you_want_to_delete_the_x_called_y'], $vbphrase['setting'], $varname, $vbphrase['varname'], $varname, ''));
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ##### Do Remove Setting ####################################################
if ($_POST['do'] == 'doremovesetting')
{
	$varname = htmlspecialchars($_POST['varname']);
	$grouptitle = htmlspecialchars($_POST['grouptitle']);
	$modid = intval($_POST['modid']);

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname' AND grouptitle = '$grouptitle'");

	$dupecheck = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname'");
	if (!$dupecheck['varname'])
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $varname . "_desc'");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $varname . "_title'");
	}

	build_adv_settings();

	if ($modid)
	{
		print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]do=editmodule&modid=$modid#settings", 0);
	}
	else
	{
		print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]do=modifysettings", 0);
	}
}

// ##### List Modules #########################################################
if ($_REQUEST['do'] == 'listmodules')
{
	print_form_header('vba_cmps_admin', 'updatemodorder');
	print_table_header($vbphrase['edit_modules'], 3);

	print_module_columns('module');

	print_table_break();

	print_submit_row($vbphrase['save_display_order'], $vbphrase['reset'], 3);
	print_table_footer();

}

// ##### Update Modual Order ##################################################
if ($_POST['do'] == 'updatemodorder')
{
	foreach ($_POST['modorder'] AS $modid => $disorder)
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET displayorder = " . intval($disorder) . " WHERE modid = " . intval($modid));
	}
	update_module_cache();

	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]do=listmodules", 0);

}

// ##### Move Module ##########################################################
if ($_REQUEST['do'] == 'movemodule')
{
	$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET modcol = " . intval($_REQUEST['col']) . " WHERE modid = " . intval($_REQUEST['modid']));

	update_module_cache();

	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]do=listmodules", 0);
}

// ##### New Module ###########################################################
if ($_REQUEST['do'] == 'newmodule' OR $_REQUEST['do'] == 'newpage')
{
	if ($_REQUEST['do'] == 'newmodule')
	{
		$type = 'module';
		$allowphrase = 'this_module';
	}
	else
	{
		$type = 'page';
		$allowphrase = 'your_custom_content';
	}

	$pageid = $vbulletin->input->clean_gpc('r', 'pageid', TYPE_INT);

	print_form_header('', '');

	print_table_header($vbphrase["$type" . _type . ""]);

	print_description_row(construct_phrase($vbphrase['please_select_type_of_x_to_add'], $vbphrase["$type"]), '', 2, 'thead');

	$urlstart = 'vba_cmps_admin.php?do=add' . $type . iif($pageid, '&amp;parentpage=' . $pageid) . '&amp;type=';

	if ($type == 'page')
	{
		print_label_row(construct_link_code($vbphrase['module'], $urlstart . 'module'), $vbphrase['module_allows_module'], 0, 'middle');
	}

	print_label_row(construct_link_code($vbphrase['bb_code'], $urlstart . 'bb_code'), construct_phrase($vbphrase['bbcode_allows_bbcode'], $vbphrase["$type"], $vbphrase["$allowphrase"]), 0, 'middle');
	print_label_row(construct_link_code($vbphrase['template'], $urlstart . 'template'), construct_phrase($vbphrase['template_allows_template'], $vbphrase["$type"], $vbphrase["$allowphrase"]), 0, 'middle');
	print_label_row(construct_link_code($vbphrase['php_file'], $urlstart . 'php_file'), construct_phrase($vbphrase['file_allows_file'], $vbphrase["$type"], $vbphrase["$allowphrase"]), 0, 'middle');

	if ($type == 'page')
	{
		$bgclass = exec_switch_bg();
		echo '<tr><td class="' . $bgclass . '" nowrap="nowrap">' . construct_link_code($vbphrase['html_file'], $urlstart . 'html_file') . '</td><td class="' . $bgclass . '">' . $vbphrase['html_allows_html'] . '</td></tr>';
	}

	print_table_footer();
}

// ##### Add / Edit Module ####################################################
if ($_REQUEST['do'] == 'addmodule' OR $_REQUEST['do'] == 'editmodule' OR $_REQUEST['do'] == 'copymodule')
{

	if ($_REQUEST['do'] == 'addmodule' AND !$_REQUEST['type'])
	{
		print_stop_message('adv_portal_must_choose_x_type', $vbphrase['module']);
	}

	?>
	<script type="text/javascript">

	function js_mod_tools(tool)
	{
		action = eval("document.vbform.tool_" + tool + ".options[document.vbform.tool_" + tool + ".selectedIndex].value");
		switch (action)
		{
			case 'copymodule':
				page = 'vba_cmps_admin.php?do=copymodule';
			break;
			case 'removemodule':
				page = 'vba_cmps_admin.php?do=removemodule';
			break;
			case 'chtype_template':
				page = 'vba_cmps_admin.php?do=editmodule&chtype=template';
			break;
			case 'chtype_php_file':
				page = 'vba_cmps_admin.php?do=editmodule&chtype=php_file';
			break;
			case 'chtype_bb_code':
				page = 'vba_cmps_admin.php?do=editmodule&chtype=bb_code';
			break;

		}
		document.vbform.reset();

		window.location = page + "&modid=<?php echo intval($_REQUEST['modid']); ?>&s=<?php echo $session['sessionhash']; ?>";
	}

	function js_template_edit(tempname)
	{
		thisstyleid = eval("document.vbform.edittemp.options[document.vbform.edittemp.selectedIndex].value");
		document.vbform.reset();

		window.location = "vba_cmps_admin.php?do=edittemp&thisstyleid=" + thisstyleid + "&tempname=" + tempname +"&s=<?php echo $session['sessionhash']; ?>";
	}

	</script>


	<?php

	$modid = $vbulletin->input->clean_gpc('r', 'modid');
	$type = $vbulletin->input->clean_gpc('r', 'type');
	$chtype = $vbulletin->input->clean_gpc('r', 'chtype');

	require_once('./includes/adminfunctions_template.php');

	if ($_REQUEST['do'] == 'editmodule' OR $_REQUEST['do'] == 'copymodule')
	{
		$headertitle = iif($_REQUEST['do'] == 'editmodule', $vbphrase['edit_module'], $vbphrase['copy']) . ': ' . $module['title'];

		if (!$module['modid'])
		{
			print_stop_message('invalid_x_specified', $vbphrase['module']);
		}

		$modopts = unserialize($module['options']);

		if ($chtype)
		{
			$module['filename'] = '';
			$type = $chtype;
		}
		else
		{
			$type = $module['inctype'];
		}
	}
	else
	{
		$headertitle = iif(empty($module), $vbphrase['add_module'], $vbphrase['copy'] . ': ' . $module['title']);
		$module['active'] = 1;
		$module['useshell'] = 1;
	}

	// Main options
	echo '<form action="vba_cmps_admin.php" name="vbform" method="post"' . iif($type == 'bb_code', ' onsubmit="return vB_Editor[\'vB_Editor_001\'].prepare_submit(0, 0)"') . '><input type="hidden" name="do" value="do' . iif($_REQUEST['do'] == 'editmodule', 'editmodule', 'addmodule') . '" /><input type="hidden" name="adminhash" value="' . ADMINHASH . '" />';

	print_table_start();

	// Module tools
	if ($_REQUEST['do'] == 'editmodule')
	{
		print_table_header($headertitle);

		if ($module['identifier'] == 'custompage')
		{
			print_description_row($vbphrase['custom_page_content_description']);
			print_table_break();
		}
		else if ($chtype)
		{
			print_description_row(construct_phrase($vbphrase['change_x_type'], $vbphrase['module']), 0, 2, 'thead');
			print_description_row(construct_phrase($vbphrase['change_x_type_note'], $vbphrase['module'], $vbphrase["$module[inctype]"], $vbphrase["$type"]));
			print_table_break();
		}
		else
		{
			print_description_row(construct_phrase($vbphrase['x_tools'], $vbphrase['module']), 0, 2, 'thead');
			print_label_row($vbphrase['select_an_action'], '<select name="tool_def" onchange="js_mod_tools(\'def\');" class="bginput">' . construct_select_options(array('noaction' => $vbphrase['please_select_one'], 'copymodule' => $vbphrase['copy'], 'removemodule' => $vbphrase['delete'])) . '</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_mod_tools(\'def\');" />', '', 'top', '', true);

			$modtypes = array(
				'noaction' => $vbphrase['please_select_one'],
				'chtype_php_file' => $vbphrase['file'],
				'chtype_template' => $vbphrase['template'],
				'chtype_bb_code' => $vbphrase['bb_code']
			);

			unset($modtypes["chtype_$type"]);

			print_label_row(construct_phrase($vbphrase['change_x_type'], $vbphrase['module']), '<select name="tool_chtype" onchange="js_mod_tools(\'chtype\');" class="bginput">' . construct_select_options($modtypes) . '</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_mod_tools(\'chtype\');" />');

			// Template options
			if ($type == 'template')
			{
				cache_styles();

				$styles = array();
				foreach ($stylecache AS $sid => $sinfo)
				{
					$styles["$sid"] = $sinfo['title'];
				}
				print_label_row(construct_phrase($vbphrase['edit_template_for_x_in_style'], $vbphrase['module']), '<select name="edittemp" onchange="js_template_edit(\'' . $module['filename'] . '\');" class="bginput">' . construct_select_options($styles) . '</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_template_edit(\'' . $module['filename'] . '\');" />');
			}
			print_table_break();
		}
	}

	// Main options
	construct_hidden_code('modid', $module['modid']);
	print_table_header($vbphrase['main_options']);
	print_input_row($vbphrase['module_title'], 'module[title]', $module['title']);
	print_select_row($vbphrase['column'], 'module[modcol]', array(0 => $vbphrase['left_column'], 2 => $vbphrase['right_column'], 1 => $vbphrase['center_column']), $module['modcol']);

	print_input_row($vbphrase['display_order'], 'module[displayorder]', $module['displayorder']);

	construct_hidden_code('module[inctype]', $type);

	print_yes_no_row($vbphrase['active_set_to_no_disable'], 'module[active]', $module['active']);

	if ($_REQUEST['do'] == 'addmodule' OR $_REQUEST['do'] == 'copymodule')
	{
		print_yes_no_row($vbphrase['update_all_pages'], 'updateall', 1);
	}

	print_table_break();

	if ($type == 'custom')
	{
		construct_hidden_code('module[identifier]', 'custompage');
	}
	else
	{
		print_table_header(construct_phrase($vbphrase['x_y_options'], $vbphrase['module'], $vbphrase["$type"]));

		switch ($type)
		{
			// File module
			case 'php_file':
				$filenames = array();

				$directory = opendir('./modules');
				while ($modfile = readdir($directory))
				{
					if (ereg('[^.]+', $modfile))
					{
						$filenames["$modfile"] = $modfile;
					}
				}

				closedir($directory);
				asort($filenames);

				print_select_row($vbphrase['file_to_include'], 'module[filename]', array_merge(array('none' => $vbphrase['choose_a_file'], 'dashes' => '--------------------'), $filenames), $module['filename']);

				$modselcache = array();
				$modselcache[''] = $vbphrase['none'];
				$getmodules = $db->query_read("SELECT identifier, title FROM " . TABLE_PREFIX . "adv_modules WHERE identifier != '' ORDER BY modcol, displayorder");
				while ($modules = $db->fetch_array($getmodules))
				{
					$modselcache["$modules[identifier]"] = $modules['title'];
				}

				$db->free_result($getmodules);
				unset($modules);

				print_select_row($vbphrase['module_parent'], 'module[parent]', $modselcache, $module['parent']);

				if ($_REQUEST['do'] == 'addmodule' OR $_REQUEST['do'] == 'copymodule')
				{
					if ($_REQUEST['do'] == 'copymodule')
					{
						$modidents = array();
						$modids = $db->query_read("SELECT identifier FROM " . TABLE_PREFIX . "adv_modules WHERE identifier LIKE '$module[identifier]%'");
						while ($modident = $db->fetch_array($modids))
						{
							$modidents[] = $modident['identifier'];
						}

						$idcount = 1;
						$oldident = $module['identifier'];
						construct_hidden_code('oldident', $oldident);
						while (!$foundident)
						{
							$idcount++;
							if (!in_array($module['identifier'] . $idcount, $modidents))
							{
								$module['identifier'] = $module['identifier'] . $idcount;
								$foundident = true;
							}
						}
					}
					print_input_row($vbphrase['identifier'], 'module[identifier]', $module['identifier']);
				}
				else
				{
					construct_hidden_code('module[identifier]', $module['identifier']);
				}
				print_textarea_row($vbphrase['templates_used'], 'module[templatelist]', $module['templatelist'], 4, 40, 1, 0);
				print_yes_no_row($vbphrase['clean_file_output'], 'module[cleanoutput]', $module['cleanoutput']);
				break;

			// Template module
			case 'template':

				echo '<tr><td class="alt2" width="100%">' . $vbphrase['template_to_include'] . '</td><td align="' . $stylevar['left'] . '" class="alt2"><span class="smallfont">adv_portal_</span><input type="text" class="bginput" name="module[filename]" id="it_module[filename]" value="' . $module['filename'] . '" size="24" /></td></tr>';

				if ($_REQUEST['do'] == 'addmodule')
				{
					print_style_chooser_row('thisstyleid', 1, '', $vbphrase['style'], 1);
					print_textarea_row(construct_phrase($vbphrase['template_content'], $vbphrase['module']), 'template', '', 20, 60, true, true, 'ltr', 'code');
				}

				break;

			// BB code module
			case 'bb_code':
				if ($_REQUEST['do'] == 'addmodule')
				{
					$modopts['allow_html'] = 1;
					$modopts['allow_smilies'] = 1;
					$modopts['allow_image_code'] = 1;
				}

				require_once('./includes/functions_editor.php');
				$textareacols = fetch_textarea_width();

				$gettemp = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "template WHERE title IN('editor_toolbar_on', 'editor_smilie', 'editor_clientscript', 'editor_toolbar_off', 'editor_jsoptions_font', 'editor_jsoptions_size', 'editor_smiliebox', 'editor_smiliebox_category', 'editor_smiliebox_row', 'editor_smiliebox_straggler') AND styleid = '-1'");
				while ($temp = $db->fetch_array($gettemp))
				{
					$vbulletin->templatecache["$temp[title]"] = $temp['template'];
				}

				$style = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "style WHERE styleid = '" . $vbulletin->options['styleid'] . "'");
				$stylevar = unserialize($style['stylevars']);

				$stycolor = unserialize($style['csscolors']);

				echo '<style type="text/css"><!--
					.wysiwyg
					{
						background-color: ' . $stycolor['wysiwyg_bgcolor'] . ';
						color: ' . $stycolor['wysiwyg_fgcolor'] . ';
						font: 10pt verdana, geneva, lucida, \'lucida grande\', arial, helvetica, sans-serif;
					}
				-->
				</style>';

				// Editor & message area
				$vbulletin->options['allowbbcode'] = 1;
				$vbulletin->options['allowbbimagecode'] = $modopts['allow_image_code'];
				construct_edit_toolbar(htmlspecialchars($module['filename']), 0, 0, $modopts['allow_smilies']);

				print_description_row(str_replace('"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $messagearea));
				print_yes_no_row($vbphrase['allow_html'], 'setting[allow_html]', $modopts['allow_html']);
				print_yes_no_row($vbphrase['allow_smilies'], 'setting[allow_smilies]', $modopts['allow_smilies']);
				print_yes_no_row($vbphrase['allow_image_code'], 'setting[allow_image_code]', $modopts['allow_image_code']);
		}

		print_table_break();

		// Module shell options
		print_table_header($vbphrase['module_shell_template_options']);
		print_description_row('<span class="smallfont">' . $vbphrase['options_apply_to_module_shell'] . '</span>', 0, 2, 'thead');
		print_yes_no_row(construct_phrase($vbphrase['use_module_shell_template'], $vbphrase['module']), 'module[useshell]', $module['useshell']);
		print_input_row(construct_phrase($vbphrase['x_link'], $vbphrase['module']), 'module[link]', $module['link']);
		print_input_row($vbphrase['title_row_colspan'], 'module[colspan]', $module['colspan']);
		print_textarea_row($vbphrase['form_code'], 'module[formcode]', $module['formcode']);

		print_table_break();

		// Usergroups
		print_table_header($vbphrase['usergroups']);
		print_description_row($vbphrase['here_specify_which_usergroups_view_module'], '', 2, 'thead', 'center');

		$module['userperms'] = explode(',', $module['userperms']);

		$usergroups = $db->query_read("SELECT usergroupid, title FROM " . TABLE_PREFIX . "usergroup ORDER BY usergroupid");
		while ($usergroup = $db->fetch_array($usergroups))
		{
			print_yes_no_row($usergroup['title'], 'userperms[' . $usergroup['usergroupid'] . ']', iif(in_array($usergroup['usergroupid'], $module['userperms']) OR $_REQUEST['do'] == 'addmodule', 1, 0));
		}

		echo '</table><a name="settings">';

		print_table_start();

		// Module Settings
		if (($_REQUEST['do'] == 'editmodule' OR $_REQUEST['do'] == 'copymodule') AND $type == 'php_file')
		{
			if ($_REQUEST['do'] == 'copymodule')
			{
				$module['identifier'] = $oldident;
			}

			// Get settings for each page
			if (!$oldident)
			{
				$getpagesettings = $db->query_read("SELECT pageid, title, advanced FROM " . TABLE_PREFIX . "adv_pages WHERE advanced != ''");
				while ($psetting = $db->fetch_array($getpagesettings))
				{
					$psetting['advanced'] = unserialize($psetting['advanced']);

					if (!empty($psetting['advanced']))
					{
						$pagesetting["$psetting[pageid]"]['title'] = $psetting['title'];
						foreach ($psetting['advanced'] AS $varname => $value)
						{
							if (!empty($value))
							{
								foreach ($value AS $vname => $settings)
								{
									$pagesettings["$varname"]["$vname"]["$psetting[pageid]"] = $psetting['title']	;
								}
							}
						}
					}
				}

				$db->free_result($getpagesettings);
				unset($psetting);
			}

			print_adv_setting_group('module', 'adv_portal_' . $module['identifier']);

			print_table_break();
		}
	}

	if ($_REQUEST['do'] == 'editmodule' AND $type == 'php_file' AND $vbulletin->debug)
	{
		echo '<div align="center" style="margin-bottom:6px">' . construct_link_code($vbphrase['add_setting'], "vba_cmps_admin.php?$session[sessionurl]do=addsetting&amp;identifier=$module[identifier]&amp;modid=$module[modid]") . '</center>';
	}

	print_submit_row();

}

// ##### Do Add / Edit Module #################################################
if ($_POST['do'] == 'doaddmodule' OR $_POST['do'] == 'doeditmodule')
{

	$modid = $vbulletin->input->clean_gpc('p', 'modid', TYPE_INT);
	$module = $vbulletin->input->clean_gpc('p', 'module');
	$setting = $vbulletin->input->clean_gpc('p', 'setting');
	$template = $vbulletin->input->clean_gpc('p', 'template');
	$userperms = $vbulletin->input->clean_gpc('p', 'userperms');
	$thisstyleid = $vbulletin->input->clean_gpc('p', 'thisstyleid', TYPE_INT);
	$oldident = $vbulletin->input->clean_gpc('p', 'oldident', TYPE_STR);
	$message = $vbulletin->input->clean_gpc('p', 'message', TYPE_STR);
	$wysiwyg = $vbulletin->input->clean_gpc('p', 'wysiwyg', TYPE_STR);

	if (!$module['title'])
	{
		print_stop_message('adv_portal_must_choose_title_for_module');
	}

	if ($module['inctype'] == 'bb_code')
	{
		$gettemp = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "template WHERE title IN('bbcode_code', 'bbcode_html', 'bbcode_php', 'bbcode_quote') AND styleid = '-1'");
		while ($temp = $db->fetch_array($gettemp))
		{
			$vbulletin->templatecache["$temp[title]"] = $temp['template'];
		}
		
		include_once('./includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

		$module['filename'] = $vbulletin->GPC['message'];
		if ($vbulletin->GPC['wysiwyg'])
		{
			require_once('./includes/functions_wysiwyg.php');
			$module['filename'] = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], $setting['allowhtml']);
		}

		$module['code_parsed'] = $bbcode_parser->do_parse($module['filename'], $setting['allow_html'], $setting['allow_smilies'], 1, $setting['allow_image_code']);
	}

	if ((!$module['filename'] AND $module['identifier'] != 'custompage' AND $module['inctype'] != 'bb_code') OR ($module['inctype'] == 'php_file' AND in_array($module['filename'], array('none', 'dashes'))))
	{
		print_stop_message('adv_portal_must_choose_' . $module['inctype'] . '_include');
	}

	if ($module['inctype'] == 'php_file' AND $_REQUEST['do'] == 'doaddmodule')
	{
		if ($checkidentifier = $db->query_first("SELECT modid FROM " . TABLE_PREFIX . "adv_modules WHERE identifier = '$module[identifier]'"))
		{
			print_stop_message('adv_portal_duplicate_identifier', $vbphrase['module'], $module['identifier']);
		}
	}

	// Insert new template
	if (trim($template))
	{
		if ($checkexist = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "template WHERE title = 'adv_portal_$module[filename]' AND styleid = '$thisstyleid'"))
		{
			print_stop_message('adv_portal_template_exists', 'adv_portal_' . $module['filename']);
		}

		require_once('./includes/adminfunctions_template.php');

		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "template
				(title, template, template_un, styleid, templatetype, dateline, username, version, product)
			VALUES (
				'adv_portal_$module[filename]',
				'" . $db->escape_string(compile_template($template)) . "',
				'" . $db->escape_string($template) ."',
				'$thisstyleid', 
				'template',
				" . TIMENOW . ",
				'" . $db->escape_string($bbuserinfo['username']) . "',
				'" . $vbulletin->options['templateversion'] . "',
				'adv_cmps'
		)");

		build_all_styles(0, 0, 'vba_cmps_admin.php?do=editmodules');
	}

	// Usergroup permissions
	if (!empty($userperms))
	{
		$ugperms = array();
		foreach ($userperms AS $usergroupid => $allow)
		{
			if ($allow)
			{
				$ugperms[] = $usergroupid;
			}
		}
		$module['userperms'] = implode(',', $ugperms);
	}

	// Duplicate the settings if copying
	if ($oldident)
	{
		$repsettings = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = 'adv_portal_$oldident'");
		while ($repsetting = $db->fetch_array($repsettings))
		{
			$repsetting['grouptitle'] = 'adv_portal_' . $module['identifier'];
			$db->query_write(fetch_query_sql($repsetting, 'adv_setting'));
		}
	}

	if (!empty($setting))
	{
		construct_cmps_settings('module');
	}

	if ($module['inctype'] == 'bb_code')
	{
		$module['options'] = serialize($setting);
	}

	if ($_POST['do'] == 'doaddmodule')
	{
		// Insert module
		$db->query_write(fetch_query_sql($module, 'adv_modules'));
		$modid = $db->insert_id();

		if ($_POST['updateall'])
		{
			$pages = $db->query_read("SELECT pageid, modules FROM " . TABLE_PREFIX . "adv_pages");
			while ($page = $db->fetch_array($pages))
			{
				$pagemodules = explode(',', $page['modules']);
				$pagemodules[] = $modid;
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET modules = '" . implode(',', $pagemodules) . "' WHERE pageid = '$page[pageid]'");
			}
		}
	}
	else
	{
		// Update module
		$db->query_write(fetch_query_sql($module, 'adv_modules', 'WHERE modid = ' . $modid));
	}

	update_module_cache();

	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]do=listmodules", 0);
}

// ##### Remove Module ########################################################
if ($_REQUEST['do'] == 'removemodule')
{
	$module = $db->query_first("SELECT modid, title FROM " . TABLE_PREFIX . "adv_modules WHERE modid = '$_REQUEST[modid]'");
	print_form_header('vba_cmps_admin', 'doremovemodule');
	construct_hidden_code('modid', $_REQUEST['modid']);
	print_table_header($vbphrase['confirm_deletion']);

	print_description_row(construct_phrase($vbphrase['are_you_sure_delete_module_called_x'], $module['title']));
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ##### Do Remove Module #####################################################
if ($_POST['do'] == 'doremovemodule')
{
	$module = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_modules WHERE modid = '$_POST[modid]'");
	if ($module['inctype'] == 'php_file')
	{
		$killphrase = array();
		$varnames = array();

		$modsettings = $db->query_read("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = 'adv_portal_$module[identifier]'");
		while ($modsetting = $db->fetch_array($modsettings))
		{
			$varnames[] = $modsetting['varname'];
		}

		if (!empty($varnames))
		{
			$dupevar = array();
			$checkdupe = $db->query_read("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle != 'adv_portal_$module[identifier]' AND varname IN('" . implode("', '", $varnames) . "')");
			while ($dupes = $db->fetch_array($checkdupe))
			{
				$dupevar[] = $dupes['varname'];
			}

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname IN('" . implode("', '", $varnames) . "') AND grouptitle = 'adv_portal_$module[identifier]'");

			$varnames = array_diff($varnames, $dupevar);

			if (!empty($varnames))
			{
				foreach ($varnames AS $pvarname)
				{
					$killphrase[] = 'setting_' . $pvarname . '_title';
					$killphrase[] = 'setting_' . $pvarname . '_desc';
				}

				$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname IN('" . implode("', '", $killphrase) . "')");
			}
		}
	}

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_modules WHERE modid = '$_POST[modid]'");
	update_module_cache();
	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]do=listmodules", 0);
}

// ##### List Pages ###########################################################
if ($_REQUEST['do'] == 'listpages')
{
	print_form_header('vba_cmps_admin', 'doorder');
	print_table_header($vbphrase['edit_pages'], 5);
	print_cells_row(array($vbphrase['title'], $vbphrase['controls'], $vbphrase['display_order'], $vbphrase['identifier'], $vbphrase['page_type']), 1);

	?>
	<script type="text/javascript">
	function js_page_jump(pageid)
	{
		action = eval("document.cpform.p" + pageid + ".options[document.cpform.p" + pageid + ".selectedIndex].value");
		switch (action)
		{
			case 'edit':
				paction = 'editpage';
			break;
			case 'remove':
				paction = 'removepage';
			break;
			case 'addchildpage':
				paction = 'newpage';
			break;
		}
		document.cpform.reset();

		window.location = "vba_cmps_admin.php?do=" + paction + "&pageid=" + pageid + "&s=<?php echo $session['sessionhash']; ?>";
	}
	</script>

	<?php

	$diroptions = array(
		'edit' => $vbphrase['edit'],
		'remove' => $vbphrase['delete'],
		'addchildpage' => $vbphrase['add_child_page']
	);

	$pagecache = array();
	$pages = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_pages ORDER BY displayorder");
	while ($page = $db->fetch_array($pages))
	{
		$pagecache["$page[pageid]"] = $page;
	}
	$db->free_result($pages);
	unset($page);

	$pages = construct_page_structure($pagecache, 0);

	foreach ($pages AS $pageid => $page)
	{
		$cells = array();
		$cells[] = '<b>' . str_repeat('- - ', ($page['level'] - 1)) . '<a href="vba_cmps_admin.php?do=editpage&amp;pageid=' . $page['pageid'] . '">' . $page['title'] . '</a></b>' . iif(!$page['active'], ' <span style="color:red;font-size:9px;font-weight:normal;">(' . $vbphrase['inactive'] . ')</span></div>');
		$cells[] = '<select name="p' . $page['pageid'] . '" onchange="js_page_jump(' . $page['pageid'] . ');" class="bginput">' . construct_select_options($diroptions) . '</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_page_jump(' . $page['pageid'] . ');" />';
		$cells[] = '<input type="text" class="bginput" name="order[' . $page['pageid'] . ']" size="3" title="' . $vbphrase['edit_display_order'] . '" value="' . $page['displayorder'] . '" />';
		$cells[] = $page['name'];
		$cells[] = $vbphrase["$page[type]"];

		print_cells_row($cells);
	}

	print_submit_row($vbphrase['save_display_order'], $vbphrase['reset'], 5);

}

// ##### Re-Order Pages #######################################################
if ($_POST['do'] == 'doorder')
{
	foreach ($_POST['order'] AS $pageid => $disorder)
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET displayorder = '$disorder' WHERE pageid = '$pageid'");
	}

	update_page_cache();

	define('CP_REDIRECT', 'vba_cmps_admin.php?do=listpages' . $session['sessionurl']);
	print_stop_message('saved_display_order_successfully');
}

// ##### Build Modules ########################################################
if ($_REQUEST['do'] == 'buildmods')
{
	update_module_cache();
}

// ##### Add / Edit Page ######################################################
if ($_REQUEST['do'] == 'addpage' OR $_REQUEST['do'] == 'editpage' OR $_REQUEST['do'] == 'copypage')
{
	if ($_REQUEST['do'] == 'addpage' AND !$_REQUEST['type'])
	{
		print_stop_message('adv_portal_must_choose_x_type', $vbphrase['page']);
	}

	$chtype = $vbulletin->input->clean_gpc('r', 'chtype', TYPE_STR);
	$pageid = $vbulletin->input->clean_gpc('r', 'pageid', TYPE_INT);
	$parentpage = $vbulletin->input->clean_gpc('r', 'parentpage', TYPE_INT);

	if (!isset($type))
	{
		$type = $vbulletin->input->clean_gpc('r', 'type', TYPE_STR);
	}

	?>
	<script type="text/javascript">

	function js_check_default(grouptitle, varname)
	{
		document.vbform[ "usedefault[" + grouptitle + "][" + varname + "]" ].checked=false
	}

	function checkAll(allbox)
	{
		var	allInputs	=	allbox.form.getElementsByTagName("input")
		var	allUsedefaults = new Array()
		for	(var i = 0;	i	<	allInputs.length;	i++)
		{
			if (allInputs[i].type	!= 'checkbox')
			continue;
			if (allInputs[i].name.match(/usedefault\[[^\]]+\]/))
			{
				allUsedefaults.push(allInputs[i])
			}
		}
		for	(var i = 0;	i	<	allUsedefaults.length; i++)
		{
			allUsedefaults[i].checked	=	allbox.checked
		}
	}

	function js_page_tools(tool)
	{
		action = eval("document.cpform.tool_" + tool + ".options[document.cpform.tool_" + tool + ".selectedIndex].value");
		switch (action)
		{
			case 'copypage':
				page = 'vba_cmps_admin.php?do=copypage';
			break;
			case 'removepage':
				page = 'vba_cmps_admin.php?do=removepage';
			break;
			case 'chtype_template':
				page = 'vba_cmps_admin.php?do=editpage&chtype=template';
			break;
			case 'chtype_html_file':
				page = 'vba_cmps_admin.php?do=editpage&chtype=html_file';
			break;
			case 'chtype_module':
				page = 'vba_cmps_admin.php?do=editpage&chtype=module';
			break;
			case 'chtype_php_file':
				page = 'vba_cmps_admin.php?do=editpage&chtype=php_file';
			break;
			case 'chtype_bb_code':
				page = 'vba_cmps_admin.php?do=editpage&chtype=bb_code';
			break;
		}
		document.cpform.reset();

		window.location = page + "&pageid=<?php echo intval($_REQUEST['pageid']); ?>&s=<?php echo $session['sessionhash']; ?>";
	}

	function js_template_edit(tempname)
	{
		thisstyleid = eval("document.cpform.edittemp.options[document.cpform.edittemp.selectedIndex].value");
		document.vbform.reset();

		window.location = "vba_cmps_admin.php?do=edittemp&type=page&thisstyleid=" + thisstyleid + "&tempname=" + tempname +"&s=<?php echo $session['sessionhash']; ?>";
	}

	</script>


	<?php

	$pages = construct_page_structure($pagecache, 0);

	if ($_REQUEST['do'] == 'addpage')
	{
		$page['active'] = 1;
		$page['useshell'] = 1;
		$adv_opts['custompage']['allow_html'] = 1;
		$adv_opts['custompage']['allow_smilies'] = 1;
		$adv_opts['custompage']['allow_image_code'] = 1;
	}
	else
	{
		if (!isset($type))
		{
			$type = $page['type'];
		}

		// Page Settings
		$adv_opts = unserialize($page['advanced']);
	}

	require_once('./includes/adminfunctions_template.php');

	// Page tools
	if ($_REQUEST['do'] == 'editpage')
	{
		print_form_header('vba_cmps_admin', 'toolsform');
		construct_hidden_code('pageid', $page['pageid']);
		print_table_header($vbphrase['edit_page'] . ': ' . $page['title']);

		if ($chtype)
		{
			$type = $chtype;
			$page['template'] = '';
			print_description_row(construct_phrase($vbphrase['change_x_type'], $vbphrase['page']), 0, 2, 'thead');
			print_description_row(construct_phrase($vbphrase['change_x_type_note'], $vbphrase['page'], $vbphrase["$page[type]"], $vbphrase["$type"]));
			print_table_footer();
		}
		else
		{
			print_description_row(construct_phrase($vbphrase['x_tools'], $vbphrase['page']), 0, 2, 'thead');
			print_label_row($vbphrase['select_an_action'], '<select name="tool_def" onchange="js_page_tools(\'def\');" class="bginput">' . construct_select_options(array('' => $vbphrase['please_select_one'], 'copypage' => $vbphrase['copy'], 'removepage' => $vbphrase['delete'])) . '</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_page_tools(\'def\');" />', '', 'top', '', true);

			$pagetypes = array(
				'' => $vbphrase['please_select_one'],
				'chtype_module' => $vbphrase['module'],
				'chtype_php_file' => $vbphrase['php_file'],
				'chtype_template' => $vbphrase['template'],
				'chtype_html_file' => $vbphrase['html_file'],
				'chtype_bb_code' => $vbphrase['bb_code']
			);

			unset($pagetypes["chtype_$type"]);

			print_label_row(construct_phrase($vbphrase['change_x_type'], $vbphrase['page']), '<select name="tool_chtype" onchange="js_page_tools(\'chtype\');" class="bginput">' . construct_select_options($pagetypes) . '</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_page_tools(\'chtype\');" />');

			// Template options
			if ($type == 'template')
			{
				cache_styles();

				$styles = array();
				foreach ($stylecache AS $sid => $sinfo)
				{
					$styles["$sid"] = $sinfo['title'];
				}
				print_label_row(construct_phrase($vbphrase['edit_template_for_x_in_style'], $vbphrase['page']), '<select name="edittemp" onchange="js_template_edit(\'' . $page['template'] . '\');" class="bginput">' . construct_select_options($styles) . '</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_template_edit(\'' . $page['template'] . '\');" />');
			}
			print_table_footer();
		}
	}

	if ($_REQUEST['do'] == 'copypage')
	{
		$pagenames = array();
		$getpages = $db->query_read("SELECT name FROM " . TABLE_PREFIX . "adv_pages WHERE name LIKE '$page[name]%'");
		while ($npages = $db->fetch_array($getpages))
		{
			$pagenames[] = $npages['identifier'];
		}

		$namecount = 1;
		while (!$foundname)
		{
			$namecount++;
			if (!in_array($page['name'] . $namecount, $pagenames))
			{
				$page['name'] = $page['name'] . $namecount;
				$foundname = true;
			}
		}
	}

	echo '<form action="vba_cmps_admin.php" name="vbform" method="post"' . iif($type == 'bb_code', ' onsubmit="return vB_Editor[\'vB_Editor_001\'].prepare_submit(0, 0)"') . '><input type="hidden" name="do" value="' . iif($_REQUEST['do'] == 'editpage', 'doeditpage', 'doaddpage') . '" /><input type="hidden" name="adminhash" value="' . ADMINHASH . '" />';

	print_table_start();
	construct_hidden_code('pageid', $page['pageid']);

	print_table_header($vbphrase['main_options']);
	construct_hidden_code('page[type]', $type);

	$meta = unserialize($page['meta']);

	print_input_row($vbphrase['page_title'], 'page[title]', $page['title']);

	if ($page['name'] == 'home')
	{
		construct_hidden_code('page[name]', 'home');
	}
	else
	{
		print_input_row($vbphrase['page_identifier'] . '<div class="smallfont">' . construct_phrase($vbphrase['page_identifier_example'], $vba_options['portal_homeurl'], $vba_options['portal_pagevar']), 'page[name]', $page['name']);
	}

	print_input_row($vbphrase['display_order'], 'page[displayorder]', $page['displayorder']);

	print_input_row($vbphrase['meta_keywords'], 'meta[keywords]', $meta['keywords']);
	print_input_row($vbphrase['meta_description'], 'meta[description]', $meta['description']);

	$pageselect = array();
	$pageselect['0'] = $vbphrase['none'];
	$pageselect['-'] = '----------------';

	foreach ($pages AS $apageid => $pageinfo)
	{
		$pageselect["$pageinfo[pageid]"] = str_repeat('- - ', ($pageinfo['level'] - 1)) . $pageinfo['title'];
	}

	print_select_row($vbphrase['parent_page'], 'page[parentid]', $pageselect, iif($_REQUEST['do'] == 'addpage', $parentpage, $page['parentid']));

	print_style_chooser_row('page[styleid]', $page['styleid'], $vbphrase['use_default_style'], $vbphrase['custom_style_for_this_page'], 1);

	print_yes_no_row($vbphrase['page_active'], 'page[active]', $page['active']);

	print_table_break();

	if ($type AND $type != 'module')
	{
		print_table_header(construct_phrase($vbphrase['x_y_options'], $vbphrase['page'], $vbphrase["$type"]));
		switch ($type)
		{
			// BB code file
			case 'bb_code':
				require_once('./includes/functions_editor.php');
				$textareacols = fetch_textarea_width();

				$gettemp = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "template WHERE styleid = '-1'");
				while ($temp = $db->fetch_array($gettemp))
				{
					$vbulletin->templatecache["$temp[title]"] = $temp['template'];
				}

				$style = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "style WHERE styleid = '" . $vbulletin->options['styleid'] . "'");

				$stylevar = array_merge(unserialize($style['stylevars']), $stylevar);
				$stycolor = unserialize($style['csscolors']);

				echo '<style type="text/css"><!--
					.wysiwyg
					{
						background-color: ' . $stycolor['wysiwyg_bgcolor'] . ';
						color: ' . $stycolor['wysiwyg_fgcolor'] . ';
						font: 10pt verdana, geneva, lucida, \'lucida grande\', arial, helvetica, sans-serif;
					}
				-->
				</style>';

				// Editor & message area
				construct_edit_toolbar(htmlspecialchars($page['template']), 0, 0, $adv_opts['custompage']['allow_smilies']);

				print_description_row(str_replace('"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $messagearea));
				print_yes_no_row($vbphrase['allow_html'], 'setting[custompage][allow_html]', $adv_opts['custompage']['allow_html']);
				print_yes_no_row($vbphrase['allow_smilies'], 'setting[custompage][allow_smilies]', $adv_opts['custompage']['allow_smilies']);
				print_yes_no_row($vbphrase['allow_image_code'], 'setting[custompage][allow_image_code]', $adv_opts['custompage']['allow_image_code']);
			break;
			// Template file
			case 'template':
				print_input_row($vbphrase['template_title'], 'page[template]', $page['template']);
			break;
			// PHP file
			case 'php_file':
				print_input_row($vbphrase['path_to_file'], 'page[template]', $page['template']);
				print_yes_no_row($vbphrase['clean_file_output'], 'page[cleanoutput]', $page['cleanoutput']);
			break;
			// HTML file
			case 'html_file':
				print_input_row($vbphrase['path_to_file'], 'page[template]', $page['template']);
				construct_hidden_code('page[cleanoutput]', 0);
			break;

		}

		print_table_break();

		print_table_header($vbphrase['module_shell_template_options']);
		print_description_row('<span class="smallfont">' . $vbphrase['options_apply_to_module_shell'] . '</span>', 0, 2, 'thead');
		print_yes_no_row(construct_phrase($vbphrase['use_module_shell_template'], $vbphrase['page']), 'page[useshell]', $page['useshell']);
		print_input_row($vbphrase['custom_content_title'], 'page[custom_title]', $page['custom_title']);
		print_input_row($vbphrase['title_row_colspan'], 'page[colspan]', $page['colspan']);
		print_textarea_row($vbphrase['form_code'], 'page[formcode]', $page['formcode']);

		print_table_break();
	}

	// Page modules
	print_table_header($vbphrase['modules_enabled'], 3);
	print_module_columns('page', true);

	print_table_break();

	print_table_header($vbphrase['usergroups']);
	print_description_row($vbphrase['here_specify_which_usergroups_access_page'], '', 2, 'thead', 'center');

	$usergroups = $db->query_read("SELECT usergroupid, title FROM " . TABLE_PREFIX . "usergroup ORDER BY usergroupid");
	while ($usergroup = $db->fetch_array($usergroups))
	{
		if ((trim($page['userperms']) AND in_array($usergroup['usergroupid'], explode(',', $page['userperms']))) OR $_REQUEST['do'] == 'addpage')
		{
			$usergroup['checked'] = 1;
		}
		print_checkbox_row($usergroup['title'], 'userperms[' . $usergroup['usergroupid'] . ']', $usergroup['checked']);
	}

	print_table_break();
	print_table_break();

	print_table_header('<span style="float:' . $stylevar['right'] . '"><label for="allbox">' . $vbphrase['all_default'] . ' <input id="allbox" name="allbox" onclick="checkAll(this);" type="checkbox" /></label></span> ' . $vbphrase['advanced_options']);
	print_description_row($vbphrase['advanced_options_description']);

	print_table_break();

	$pageid = $page['pageid'];

	print_adv_setting_group('page');

	print_submit_row();
}

// ##### Do Add / Edit Page ###################################################
if ($_POST['do'] == 'doaddpage' OR $_REQUEST['do'] == 'doeditpage')
{

	$page = $vbulletin->input->clean_gpc('p', 'page');
	$enablemod = $vbulletin->input->clean_gpc('p', 'enablemod');
	$setting = $vbulletin->input->clean_gpc('p', 'setting');
	$usedefault = $vbulletin->input->clean_gpc('p', 'usedefault');
	$userperms = $vbulletin->input->clean_gpc('p', 'userperms');
	$pageid = $vbulletin->input->clean_gpc('p', 'pageid', TYPE_INT);
	$meta = $vbulletin->input->clean_gpc('p', 'meta');
	$message = $vbulletin->input->clean_gpc('p', 'message');
	$wysiwyg = $vbulletin->input->clean_gpc('p', 'wysiwyg');

	if ($checkidentifier = $db->query_first("SELECT pageid FROM " . TABLE_PREFIX . "adv_pages WHERE name = '$page[name]' AND pageid != '$pageid'"))
	{
		print_stop_message('adv_portal_duplicate_identifier', $vbphrase['page'], $page['name']);
	}

	if ($_POST['do'] == 'doeditpage' AND $page['parentid'] == $pageid)
	{
		print_stop_message('adv_portal_cant_parent_page_itself', $vbphrase['page'], $page['name']);
	}

	if (!trim($page['title']))
	{
		print_stop_message('adv_portal_must_enter_x_for_page', $vbphrase['title']);
	}

	if (!trim($page['name']))
	{
		print_stop_message('adv_portal_must_enter_x_for_page', $vbphrase['identifier']);
	}

	if ($page['type'] == 'php_file' OR $page['type'] == 'html_file')
	{
		if (!is_file($page['template']))
		{
			print_stop_message('adv_portal_invalid_file_path', $vbphrase["$page[type]"]);
		}
	}

	$page['meta'] = serialize($meta);

	if ($page['type'] == 'bb_code')
	{
		$page['template'] = $message;
		if ($wysiwyg)
		{
			require_once('./includes/functions_wysiwyg.php');
			$page['template'] = convert_wysiwyg_html_to_bbcode($message);
		}
	}

	$adv_opts = array();

	$getadv_settings = $db->query_read("SELECT varname, value, grouptitle FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle LIKE 'adv_portal%'");
	while ($adv_settings = $db->fetch_array($getadv_settings))
	{
		$adv_opts["$adv_settings[identifier]"]["$varname"] = $value;
	}

	$pageadv = $db->query_first("SELECT advanced FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = '$pageid'");
	$pageadv['advanced'] = unserialize($pageadv['advanced']);

	if (!empty($pageadv['advanced']))
	{
		foreach ($pageadv['advanced'] AS $modident => $modopt)
		{
			if (!empty($modopt))
			{
				foreach ($modopt AS $mvar => $mvalue)
				{
					if ($mvar == 'portal_threadids' AND !$usedefault["$modident"]["$mvar"])
					{
						$adv_setting["$modident"]["$mvar"] = $mvalue;
					}
				}
			}
		}
	}

	if (!empty($adv_opts))
	{
		foreach ($setting AS $identifier => $modopts)
		{
			if (is_array($modopts))
			{
				foreach ($modopts AS $varname => $value)
				{
					if (!$usedefault["$identifier"]["$varname"] AND $adv_opts["$identifier"]["$varname"] != $value)
					{
						if ($varname == 'portal_navigation_addpages')
						{
							if ($value)
							{
								$pagelinks = array();
								foreach ($value AS $key => $array)
								{
									if ($array['text'])
									{
										foreach ($array AS $akey => $avalue)
										{
											$pagelinks["$key"]["$akey"] = $avalue;
										}
									}
								}
							}
							function order_nav($a, $b)
							{
								return ($a['order'] < $b['order']) ? -1 : 1;
							}
							usort($pagelinks, 'order_nav');

							$adv_setting["$identifier"]["$varname"] = serialize($pagelinks);
						}
						else if (is_array($value))
						{
							$adv_setting["$identifier"]["$varname"] = implode(',', $value);
						}
						else if ($varname != 'portal_threadids')
						{
							$adv_setting["$identifier"]["$varname"] = $value;
						}
					}
				}
			}
		}
	}

	$page['advanced'] = serialize($adv_setting);

	$page['modules'] = '';
	if (!empty($enablemod))
	{
		$page['modules'] = implode(',', $enablemod);
	}

	$page['userperms'] = '';
	if (!empty($userperms))
	{
		$page['userperms'] = implode(',', array_keys($userperms));
	}

	if ($page['styleid'] == '-1')
	{
		$page['styleid'] = 0;
	}

	$db->query_write(fetch_query_sql($page, 'adv_pages', iif($_POST['do'] == 'doeditpage', 'WHERE pageid = ' . $pageid)));

	if ($_POST['do'] == 'doaddpage')
	{
		$pageid = $db->insert_id();
	}

	rebuild_parents($pageid);

	update_page_cache();

	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]do=listpages", 0);
}

// ##### Remove Page ##########################################################
if ($_REQUEST['do'] == 'removepage')
{
	$page = $db->query_first("SELECT pageid, title, name FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = '$_REQUEST[pageid]'");
	if ($page['name'] == 'home')
	{
		print_stop_message('adv_portal_cant_remove_default');
	}
	print_form_header('vba_cmps_admin', 'doremovepage');
	construct_hidden_code('pageid', $page['pageid']);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row(construct_phrase($vbphrase['are_you_sure_delete_page_called_x'], $page['title']));
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ##### Do Remove Page #######################################################
if ($_POST['do'] == 'doremovepage')
{
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = '$_POST[pageid]'");

	update_page_cache();

	print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]do=listpages", 0);
}

// ##### Download / Upload Module #############################################
if ($_REQUEST['do'] == 'download')
{
	require_once('./includes/adminfunctions_template.php');

	print_form_header('vba_cmps_admin', 'uploadmodule', true);

	// Upload module
	print_table_header($vbphrase['upload_module']);
	print_description_row($vbphrase['main_options'], 0, 2, 'thead');
	print_upload_row($vbphrase['select_module_upload'], 'modfile');

	print_select_row($vbphrase['column'], 'module[modcol]', array(0 => $vbphrase['left_column'], 2 => $vbphrase['right_column'], 1 => $vbphrase['center_column']), $module['modcol']);
	print_input_row($vbphrase['display_order'], 'module[displayorder]', $module['displayorder']);
	print_yes_no_row($vbphrase['active_set_to_no_disable'], 'module[active]', 1);
	print_yes_no_row($vbphrase['update_all_pages'], 'updateall', 0);

	cache_styles();

	$styles = array();
	$styles[''] = $vbphrase['please_select_one'];

	foreach($stylecache AS $style)
	{
		$styles["$style[styleid]"] = construct_depth_mark($style['depth'], '--', iif($displaytop, '--')) . ' ' . $style['title'];
	}

	print_select_row($vbphrase['style_to_install_to'], 'thisstyleid', $styles);

	print_description_row($vbphrase['usergroups'], 0, 2, 'thead');
	$usergroups = $db->query_read("SELECT usergroupid, title FROM " . TABLE_PREFIX . "usergroup ORDER BY usergroupid");
	while ($usergroup = $db->fetch_array($usergroups))
	{
		print_yes_no_row($usergroup['title'], 'userperms[' . $usergroup['usergroupid'] . ']', 1);
	}


	print_submit_row($vbphrase['submit'], '');

	// Download module
	print_form_header('vba_cmps_admin', 'downloadmodule');
	print_table_header($vbphrase['download_module'], 3);
	print_description_row($vbphrase['tool_downloads_module'], '', 3, 'alt1');
	print_module_columns('download');
	print_submit_row($vbphrase['download'], '', 3);
}

// ##### Upload Module ########################################################
if ($_POST['do'] == 'uploadmodule')
{
	$module = $_POST['module'];
	$userperms = $_POST['userperms'];
	$thisstyleid = intval($_POST['thisstyleid']);
	$haderrors = intval($_POST['haderrors']);
	$updateall = intval($_POST['updateall']);
	$identifier = htmlspecialchars($_POST['identifier']);
	$filename = htmlspecialchars($_POST['filename']);
	$modulefilename = htmlspecialchars($_POST['modulefilename']);
	$modfile = $_FILES['modfile'];

	if (!is_writable('./modules/'))
	{
		print_stop_message('adv_portal_moddir_notwritable');
	}

	if (!$haderrors)
	{
		@chmod('./modules', 0777);
		@move_uploaded_file($modfile['tmp_name'], './modules/' . $modfile['name']);
	}
	else
	{
		$moduleinfo['module'] = $module;
		$modfile['name'] = $modulefilename;
	}

	if (substr($modfile['name'], -7) != '.module')
	{
		@unlink('./modules/' . $modfile['name']);
		print_stop_message('adv_portal_invalid_modfile');
	}

	if ($fp = @fopen('./modules/' . $modfile['name'], 'r'))
	{
		$moduleinfo = unserialize(fread($fp, filesize('./modules/' . $modfile['name'])));
		fclose($fp);
	}

	if (empty($moduleinfo['module']))
	{
		@unlink('./modules/' . $modfile['name']);
		print_stop_message('adv_portal_invalid_modfile');
	}

	$module = array_merge(unserialize($moduleinfo['module']), $module);

	if ($identifier)
	{
		$module['identifier'] = $identifier;
	}

	if ($filename)
	{
		$module['filename'] = $filename;
	}

	$moderrors = array();

	if ($module['inctype'] == 'php_file')
	{
		if (is_file('./modules/' . $module['filename']) AND $moduleinfo['file'])
		{
			$moderrors['duplicate_filename'] = $module['filename'];
		}
		if ($checkidentifier = $db->query_first("SELECT modid FROM " . TABLE_PREFIX . "adv_modules WHERE identifier = '$module[identifier]'"))
		{
			$moderrors['duplicate_module_identifier'] = $module['identifier'];
		}
	}

	// Usergroup permissions
	if (!empty($userperms))
	{
		$ugperms = array();
		foreach ($userperms AS $usergroupid => $allow)
		{
			if ($allow)
			{
				$ugperms[] = $usergroupid;
			}
		}
		$module['userperms'] = implode(',', $ugperms);
	}

	$moduleinfo['templates'] = unserialize($moduleinfo['templates']);

	if (!empty($moduleinfo['templates']) AND !isset($_REQUEST['overwrite']))
	{
		if (!$thisstyleid)
		{
			print_stop_message('adv_portal_choose_style');
		}

		$currenttemplates = array();
		$checktemps = $db->query_read("SELECT title FROM " . TABLE_PREFIX . "template WHERE title IN('" . implode('\',\'', array_keys($moduleinfo['templates'])) . "') AND styleid = '$thisstyleid'");
		while ($template = $db->fetch_array($checktemps))
		{
			$currenttemplates[] = $template['title'];
		}
		$db->free_result($checktemps);
		unset($template);

		foreach ($moduleinfo['templates'] AS $title => $template)
		{
			if (in_array($title, $currenttemplates))
			{
				$moderrors['overwrite_templates'][] = $title;
			}
		}
	}

	// Got errros
	if (sizeof($moderrors) > 0)
	{
		$_REQUEST['do'] = 'uploaderrors';
	}
	else
	{
		// No errors, so let's process the module

		// Process templates
		if ($moduleinfo['templates'] AND (!isset($_REQUEST['overwrite']) OR $_REQUEST['overwrite'] == 1))
		{
			require_once('./includes/adminfunctions_template.php');

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title IN('" . implode('\',\'', array_keys($moduleinfo['templates'])) . "') AND styleid = '$thisstyleid'");

			foreach ($moduleinfo['templates'] AS $title => $template)
			{
				$db->query_write("
					INSERT INTO " . TABLE_PREFIX . "template
						(title, template, template_un, styleid, templatetype, dateline, username, version)
					VALUES (
						'$title',
						'" . $db->escape_string(compile_template($template)) . "',
						'" . $db->escape_string($template) ."',
						'$thisstyleid',
						'template', 
						" . TIMENOW . ",
						'" . $db->escape_string($bbuserinfo['username']) . "',
						'" . $vbulletin->options['version'] . "'
				)");

			}
			build_all_styles(0, 0);
		}

		// Insert module
		$db->query_write(fetch_query_sql($module, 'adv_modules'));
		$modid = $db->insert_id();

		// Update all pages
		if ($updateall)
		{
			$pages = $db->query_read("SELECT pageid, modules FROM " . TABLE_PREFIX . "adv_pages");
			while ($page = $db->fetch_array($pages))
			{
				$pagemodules = explode(',', $page['modules']);
				$pagemodules[] = $modid;
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET modules = '" . implode(',', $pagemodules) . "' WHERE pageid = '$page[pageid]'");
			}
		}

		// Write module file
		if ($module['inctype'] == 'php_file')
		{
			if ($fp = fopen('./modules/' . $module['filename'], "w"))
			{
				fputs ($fp, $moduleinfo['file']);
				fclose($fp);
			}
		}

		// Module settings
		if (!empty($moduleinfo['settings']))
		{
			$currentsettings = array();
			$getsettings = $db->query_read("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname IN('" . implode('\',\'', array_keys($moduleinfo['settings'])) . "')");
			while ($setting = $db->fetch_array($getsettings))
			{
				$currentsettings[] = $setting['varname'];
			}

			$db->free_result($getsettings);
			unset($setting);

			foreach ($moduleinfo['settings'] AS $varname => $setting)
			{
				if (!in_array($varname, $currentsettings))
				{
					$db->query_write("
						INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
							(languageid, varname, text, fieldname, product)
						VALUES (
							0,
							'setting_" . $varname . "_title',
							'" . $db->escape_string($setting['title']) ."',
							'vbsettings',
							'adv_cmps'
					)");
					$db->query_write("
						INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
							(languageid, varname, text, fieldname, product)
						VALUES (
							0,
							'setting_" . $varname . "_desc',
							'" . $db->escape_string($setting['description']) . "',
							'vbsettings',
							'adv_cmps'
					)");
				}

				$db->query_write("
					INSERT INTO " . TABLE_PREFIX . "adv_setting
						(varname, grouptitle, value, defaultvalue, optioncode, displayorder)
					VALUES (
						'$varname',
						'adv_portal_$module[identifier]',
						'" . $db->escape_string($setting['value']) . "',
						'" . $db->escape_string($setting['defaultvalue']) . "',
						'" . $db->escape_string($setting['optioncode']) . "',
						'$setting[displayorder]'
				)");
			}
		}
		// Delete the .module file
		unlink('./modules/' . $modfile['name']);

		update_module_cache();
		build_adv_settings();

		print_cp_redirect("vba_cmps_admin.php?$session[sessionurl]do=listmodules", 0);
	}
}

// ##### Upload Errors ########################################################
if ($_REQUEST['do'] == 'uploaderrors')
{
	print_form_header('vba_cmps_admin', 'uploadmodule');
	construct_hidden_code('thisstyleid', $thisstyleid);
	construct_hidden_code('haderrors', 1);
	construct_hidden_code('modulefilename', $modfile['name']);
	construct_hidden_code('updateall', $updateall);

	if (isset($identifier) AND !in_array('duplicate_module_identifier', array_keys($moderrors)))
	{
		construct_hidden_code('identifier', $identifier);
	}

	if (isset($filename) AND !in_array('duplicate_filename', array_keys($moderrors)))
	{
		construct_hidden_code('filename', $filename);
	}

	if (isset($_REQUEST['overwrite']))
	{
		construct_hidden_code('overwrite', $_REQUEST['overwrite']);
	}

	$errornames = array_keys($moderrors);

	foreach ($module AS $varname => $value)
	{
		construct_hidden_code('module[' . $varname . ']', $value);
	}

	print_table_header($vbphrase['error']);


	foreach ($moderrors AS $phrase => $value)
	{
		print_description_row($vbphrase["$phrase"], '', 2, 'thead');

		switch ($phrase)
		{
			case 'overwrite_templates':
				$templatenames = array();
				foreach ($value AS $tempname)
				{
					$templatenames[] = '<b>' . $tempname . '</b>';
				}
				print_yes_no_row(construct_phrase($vbphrase["$phrase" . _desc . ""], implode(', ', $templatenames)), 'overwrite', 0);
				break;

			case 'duplicate_filename':
				print_input_row(construct_phrase($vbphrase["$phrase" . _desc . ""], $value), 'filename', $value);
				break;

			case 'duplicate_module_identifier':
				print_input_row(construct_phrase($vbphrase["$phrase" . _desc . ""], $value), 'identifier', $value);
				break;

		}
	}
	print_submit_row();
}

// ##### Edit Module Threads (show forums) ####################################
if ($_REQUEST['do'] == 'listforums')
{
	$identifier = htmlspecialchars($_REQUEST['identifier']);

	if ($_REQUEST['pageid'] == 'newpage')
	{
		print_stop_message('adv_portal_threads_save_page');
	}

	$pageid = intval($_REQUEST['pageid']);

	if ($pageid)
	{
		$page = $db->query_first("SELECT advanced FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = '$pageid'");
		$page['advanced'] = unserialize($page['advanced']);
		$threadids = unserialize($page['advanced']["adv_portal_$identifier"]['portal_threadids']);
	}
	if (!$pageid OR empty($threadids))
	{
		$threadids = fetch_module_threadids($identifier);
	}

	if (!empty($threadids))
	{
		print_form_header('vba_cmps_admin', 'removethreads');
		construct_hidden_code('identifier', $identifier);
		construct_hidden_code('pageid', $pageid);
		print_table_header($vbphrase['current_selected_threads'], 3);
		print_cells_row(array($vbphrase['remove'], $vbphrase['title'], $vbphrase['forum']), 1, '', -2);

		$getthreads = $db->query_read("SELECT threadid, title, forumid FROM " . TABLE_PREFIX . "thread WHERE threadid IN(" . implode(',', array_keys($threadids)) . ")");
		while ($thread = $db->fetch_array($getthreads))
		{
			$class = exec_switch_bg();
			echo '<tr><td align="center" class="' . $class . '" width="40"><input name="threadids[]" value="' . $thread['threadid'] . '" type="checkbox"></td><td class="' . $class . '"><a href="' . $vbulletin->options['bburl'] . '/showthread.php?' . $session['sessionurl'] . 't=' . $thread['threadid'] . '" target="_blank">' . $thread['title'] . '</a></td><td class="' . $class . '" width="250"><a href="' . $vbulletin->options['bburl'] . '/forumdisplay.php?' . $session['sessionurl'] . 'f=' . $thread['forumid'] . '" target="_blank">' . $forumcache["$thread[forumid]"]['title'] . '</a></td></tr>';
		}
		print_submit_row($vbphrase['remove'], '', 3);
	}

	print_form_header('', '');
	print_table_header($vbphrase['select_new_threads']);
	print_description_row($vbphrase['to_begin_selecting_threads'], 0, 2, 'thead');
	foreach ($vbulletin->forumcache AS $forum)
	{
		$forumoptions = array();
		foreach($vbulletin->bf_misc_forumoptions AS $optname => $optval)
		{
			$forumoptions["$optname"] = iif(($forum['options'] & $optval), 1, 0);
		}

		if (!$forumoptions['cancontainthreads'])
		{
			print_description_row('<i>' . str_repeat('--', $forum['depth']) . $forum['title'] . '</i>', 0, 2, 'alt1');
		}
		else
		{
			print_description_row(str_repeat('--', $forum['depth']) . ' <a href="vba_cmps_admin.php?do=threadids&amp;identifier=' . $identifier . '&amp;forumid=' . $forum['forumid'] . '&amp;pageid=' . $pageid . '">' . $forum['title'] . '</a>', 0, 2, 'alt2');
		}
	}

	print_table_footer();
}

// ##### Show Threads in Forum ################################################
if ($_REQUEST['do'] == 'threadids')
{
	$forumid = intval($_REQUEST['forumid']);
	$page = intval($_REQUEST['page']);
	$identifier = htmlspecialchars($_REQUEST['identifier']);
	$pageid = intval($_REQUEST['pageid']);
	$threadids = $_REQUEST['threadids'];
	$gotopagenumber = $_REQUEST['gotopagenumber'];
	$currentpage = intval($_REQUEST['currentpage']);

	// Do submit threadids
	if ($_POST['dosubmit'])
	{
		// Updating for specific page only
		if ($pageid)
		{
			$page = $db->query_first("SELECT advanced FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = '$pageid'");
			$page['options'] = unserialize($page['advanced']);

			$threadarray = array();

			if (!empty($threadids))
			{
				$posts = $db->query_read("SELECT threadid, firstpostid FROM " . TABLE_PREFIX . "thread WHERE threadid IN(" . implode(',', array_keys($threadids)) . ")");
				while ($post = $db->fetch_array($posts))
				{
					$threadarray["$post[threadid]"] = $post['firstpostid'];
				}
			}

			$page['options']["adv_portal_$identifier"]['portal_threadids'] = serialize($threadarray);

			$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET advanced = '" . serialize($page['options']) . "' WHERE pageid = '$pageid'");
		}
		else
		{
			// Updating the module
			$threadarray = fetch_module_threadids($identifier);

			$threadarray = array();
			$posts = $db->query_read("SELECT threadid, firstpostid FROM " . TABLE_PREFIX . "thread WHERE threadid IN(" . implode(',', array_keys($threadids)) . ")");
			while ($post = $db->fetch_array($posts))
			{
				$threadarray["$post[threadid]"] = $post['firstpostid'];
			}

			$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . serialize($threadarray) . "' WHERE grouptitle = 'adv_portal_$identifier' AND varname = 'portal_threadids'");

			build_adv_settings();
		}

		print_cp_redirect('vba_cmps_admin.php?do=listforums&identifier=' . $identifier . '&amp;pageid=' . $pageid);

	}
	else
	{
		// Browsing forum for threads
		$wherequery = array('forumid = ' . $forumid);
		$pagedata = fetch_page_data('thread');

		print_form_header('vba_cmps_admin', 'threadids');
		construct_hidden_code('forumid', $forumid);
		construct_hidden_code('identifier', $identifier);
		construct_hidden_code('pageid', $pageid);

		if ($gotopagenumber)
		{
			switch ($gotopagenumber)
			{
				case $vbphrase['last'] . ' ':
					$_REQUEST['page'] = $pagedata['pagecount'];
				break;
				case ' ' . $vbphrase['first']:
					$_REQUEST['page'] = 1;
				break;
				case '< ' . $vbphrase['prev']:
					$_REQUEST['page'] = $currentpage - 1;
				break;
				case $vbphrase['next'] . ' >':
					$_REQUEST['page'] = $currentpage + 1;
				break;
			}
			$pagedata = fetch_page_data('thread');
		}
		construct_hidden_code('currentpage', $pagedata['pagenumber']);

		// Construct the pagenav
		if ($pagedata['pagecount'] > 1)
		{
			if ($pagedata['pagenumber'] != 1)
			{
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="&laquo; ' . $vbphrase['first'] . '" /> ';
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="&lt; ' . $vbphrase['prev'] . '" /> ';
			}

			$i = 0;
			$thispage = $pagedata['pagenumber'] - 5;

			if ($pagedata['pagenumber'] + 5 > $pagedata['pagecount'])
			{
				$thispage = $pagedata['pagecount'] - 9;
			}

			if ($thispage < 0)
			{
				$thispage = 0;
			}

			$pageprint = iif($pagedata['pagecount'] >= 9, 9, $pagedata['pagecount']);

			while ($i++ < $pageprint)
			{
				$thispage++;
				$pagenav .= '<input class="button" name="page" type="submit" value="' . iif($thispage > 9, $thispage, ' ' . $thispage . ' ') . '"' . iif($pagedata['pagenumber'] == $thispage, ' disabled="disabled"') . ' /> ';
			}

			if ($pagedata['pagenumber'] != $pagedata['pagecount'])
			{
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="' . $vbphrase['next'] . ' &gt;" /> ';
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="' . $vbphrase['last'] . ' &raquo;" />';
			}
		}

		print_table_header('<span style="float:' . $stylevar['right'] . '">' . $pagenav . '</span>' . $vbulletin->forumcache["$forumid"]['title'], 2, 0, '', $stylevar['left']);

		$selectedthreads = array();

		if (!$page)
		{
			if ($pageid)
			{
				$page = $db->query_first("SELECT advanced FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = '$pageid'");
				$page['advanced'] = unserialize($page['advanced']);
				$keyoptions = unserialize($page['advanced']["adv_portal_$identifier"]['portal_threadids']);
			}

			if (!isset($keyoptions))
			{
				$keyoptions = fetch_module_threadids($identifier);
			}

			if (!empty($keyoptions))
			{
				$curthreads = array_keys($keyoptions);

				$getthreads = $db->query_read("SELECT threadid, title, forumid FROM " . TABLE_PREFIX . "thread WHERE threadid IN(" . implode(',', $curthreads) . ")");
				while ($thread = $db->fetch_array($getthreads))
				{
					$selectedthreads[] = $thread['threadid'];
					$threadids["$thread[threadid]"] = $thread['firstpostid'];
				}
			}
		}

		unset($threadid);

		$tids = array();
		$getthreadids = $db->query_read("SELECT threadid FROM " . TABLE_PREFIX . "thread WHERE forumid = $forumid ORDER BY lastpost DESC LIMIT " . ($pagedata['minlimit'] - 1) . ", $pagedata[perpage]");
		while ($threadid = $db->fetch_array($getthreadids))
		{
			$tids[] = $threadid['threadid'];
		}

		if (!empty($tids))
		{
			// Get selected ids
			if (!empty($threadids))
			{
				foreach ($threadids AS $threadid => $firstpostid)
				{
					$selectedthreads[] = $threadid;
				}
			}

			$getthreads = $db->query_read("SELECT threadid, title, postusername, firstpostid, pollid FROM " . TABLE_PREFIX . "thread WHERE threadid IN(" . implode(',', $tids) . ") ORDER BY lastpost DESC");
			while ($thread = $db->fetch_array($getthreads))
			{
				unset($threadids["$thread[threadid]"]);
				$class = exec_switch_bg();
				echo '<tr><td align="center" class="' . $class . '"><input ' . iif(in_array($thread['threadid'], $selectedthreads), 'checked="checked"') . ' type="checkbox" name="threadids[' . $thread['threadid'] . ']" value="' . $thread['firstpostid'] . '" /></td><td class="' . $class . '" width="100%">' . iif($thread['pollid'], $vbphrase['poll'] . ': ') . construct_link_code(stripslashes($thread['title']), $vbulletin->options['bburl'] . '/showthread.php?t=' . $thread['threadid'], 1) . '</td></tr>';
			}

			// Print hidden inputs for any not listed above
			if (!empty($threadids))
			{
				foreach ($threadids AS $threadid => $firstpostid)
				{
					$selectedthreads[] = $threadid;
					construct_hidden_code('threadids[' . $threadid . ']', $firstpostid);
				}
			}

			print_table_footer(2, '<input type="submit" name="dosubmit" value="' . $vbphrase['submit'] . '" />');
		}
		else
		{
			print_description_row(construct_phrase($vbphrase['no_x_to_display'], $vbphrase['threads']));
			print_table_footer();
		}
	}
}

// ##### Remove Module Threads ################################################
if ($_POST['do'] == 'removethreads')
{
	$threadids = $_POST['threadids'];
	$identifier = $_POST['identifier'];
	$pageid = intval($_POST['pageid']);

	if ($pageid)
	{
		$page = $db->query_first("SELECT advanced FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = '$pageid'");
		$page['advanced'] = unserialize($page['advanced']);

		if (!isset($page['advanced']["adv_portal_$identifier"]['portal_threadids']))
		{
			$ptids = unserialize($page['advanced']["adv_portal_$identifier"]['portal_threadids']);
			$ptids = fetch_module_threadids($identifier);
		}

		foreach ($threadids AS $threadid)
		{
			unset($ptids["$threadid"]);
		}

		$page['advanced']["adv_portal_$identifier"]['portal_threadids'] = serialize($ptids);

		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET advanced = '" . serialize($page['advanced']) . "'");
	}
	else
	{
		$curthreads = fetch_module_threadids($identifier);

		foreach ($threadids AS $threadid)
		{
			unset($curthreads["$threadid"]);
		}

		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . serialize($curthreads) . "' WHERE grouptitle = 'adv_portal_$identifier' AND varname = 'portal_threadids'");
	}

	build_adv_settings();

	print_cp_redirect('vba_cmps_admin.php?do=listforums&identifier=' . $identifier . '&amp;pageid=' . $pageid);
}

// ##### Quick Permissions ####################################################
if ($_REQUEST['do'] == 'permissions')
{
	print_form_header('vba_cmps_admin', 'dopermissions');
	print_table_header($vbphrase['pages']);

	// Pages
	$ppcache = array();
	$pageperms = $db->query_read("SELECT pageid, title, parentid, userperms FROM " . TABLE_PREFIX . "adv_pages ORDER BY displayorder");
	while ($page = $db->fetch_array($pageperms))
	{
		$ppcache["$page[pageid]"] = $page;
	}

	$db->free_result($pageperms);
	unset($page);

	$ppcache = construct_page_structure($ppcache);

	foreach ($ppcache AS $pid => $page)
	{
		print_description_row($page['title'], 0, 2, 'thead');
		foreach ($vbulletin->usergroupcache AS $ugroup)
		{
			print_checkbox_row($ugroup['title'], 'pageperms[' . $pid . '][' . $ugroup['usergroupid'] . ']', iif(in_array($ugroup['usergroupid'], explode(',', $page['userperms'])), 1));
		}
	}

	print_table_break();
	print_table_break();

	// Modules
	print_table_header($vbphrase['modules']);

	$modcache = array();
	$getmods = $db->query_read("SELECT modid, title, userperms FROM " . TABLE_PREFIX . "adv_modules ORDER BY modcol, displayorder");
	while ($mods = $db->fetch_array($getmods))
	{
		$modcache["$mods[modid]"] = $mods;
	}

	foreach ($modcache AS $modid => $mod)
	{
		print_description_row($mod['title'], 0, 2, 'thead');
		foreach ($vbulletin->usergroupcache AS $ugroup)
		{
			print_checkbox_row($ugroup['title'], 'modperms[' . $modid . '][' . $ugroup['usergroupid'] . ']', iif(in_array($ugroup['usergroupid'], explode(',', $mod['userperms'])), 1));
		}
	}

	print_submit_row();

}

// ##### Save Quick Permissions ###############################################
if ($_POST['do'] == 'dopermissions')
{
	$pageperms = $_POST['pageperms'];
	$modperms = $_POST['modperms'];

	$getpages = $db->query_read("SELECT pageid FROM " . TABLE_PREFIX . "adv_pages");
	while ($page = $db->fetch_array($getpages))
	{
		$pagegroups = '';
		if (!empty($pageperms["$page[pageid]"]))
		{
			$pagegroups = implode(',', array_keys($pageperms["$page[pageid]"]));
		}
		
		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET userperms = '" . $pagegroups . "' WHERE pageid = '$page[pageid]'");
	}

	$getmods = $db->query_read("SELECT modid FROM " . TABLE_PREFIX . "adv_modules");
	while ($mod = $db->fetch_array($getmods))
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET userperms = '" . implode(',', array_keys($modperms["$mod[modid]"])) . "' WHERE modid = '$mod[modid]'");
	}

	update_module_cache();

	print_cp_redirect('vba_cmps_admin.php?do=permissions');

}

// ##### Edit Template ########################################################
if ($_REQUEST['do'] == 'edittemp')
{
	$thisstyleid = intval($_REQUEST['thisstyleid']);
	$temptitle = iif($_REQUEST['type'] != 'page', 'adv_portal_') . $db->escape_string($_REQUEST['tempname']);

	$template = $db->query_first("SELECT templateid FROM " . TABLE_PREFIX . "template WHERE title = '$temptitle' AND styleid = $thisstyleid");

	print_cp_redirect('template.php?' . iif($template['templateid'], 'do=edit&templateid=' . $template['templateid'], 'do=add&dostyleid=' . $thisstyleid . '&title=' . $temptitle));

}

// ##### Rebuild Parents ######################################################
if ($_REQUEST['do'] == 'rebuildparents')
{
	rebuild_parents(0);
}

// Print footer
if ($_REQUEST['do'] != 'downloadmodule')
{
	print_cp_footer();
}

?>